<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Comment_Shortcode extends Pf_Plugin_Shortcode_Controller
{

    private $key;
    private $settings = array();

    public function __construct($attrs)
    {
        parent::__construct();
        $this->view->set_path('/plugins/comment/public/views');
        $this->model = new Pf_Comment_Model;
        $this->setting->set_name('pf_comment');
        $this->key = isset($attrs['key']) ? $attrs['key'] : '';
        $this->get_setting();
    }

    /*
     * Geting setting of comment
     */

    private function get_setting()
    {
        $setting = Pf::setting();
        $approve_flag = $this->clean_setting('approve_flag');
        $approve = $this->setting->get_value('approve');
        if (is_array($approve) && in_array(current_user('user-id'), $approve)) {
            $approve_flag = 0;
        }
        $this->settings = array(
            'approve_flag' => $approve_flag,
            'ordering' => $this->clean_setting('ordering'),
            'maximum_characters' => $this->clean_setting('maximum_characters', 255),
            'maximum_level' => $this->clean_setting('maximum_level', 5),
            'approve' => $this->setting->get_value('approve'),
            'site_name' => $setting->get_element_value('general', 'site_name'),
            'email' => noreply_email()
        );
    }

    private function clean_setting($key, $default = 0)
    {
        return $this->setting->get_value($key) == '' ? $default : $this->setting->get_value($key);
    }

    private function get_comment($data)
    {
        $nodes = array();
        $tree = array();
        foreach ($data as &$node) {
            $node->children = array();
            $id = $node->id;
            $parent_id = $node->comment_parent;
            $nodes[$id] = & $node;
            if (array_key_exists($parent_id, $nodes)) {
                $nodes[$parent_id]->children[] = & $node;
            } else {
                $tree[] = & $node;
            }
        }
        return $tree;
    }

    /*
     * Show main content
     */

    public function comment_main()
    {
        $data = array(
            'token' => Pf_Plugin_CSRF::token($this->key),
            'key' => $this->key
        );
        $this->data = array_merge($data, $this->settings);
        return $this->view->render('main', $this->data);
    }

    public function comment_load_comment()
    {
        if (!is_ajax()) {
            return;
        }
        $key = $this->input->post('key');
        $conditions = "comment_key = ? and comment_status = 1 ";
        $order_by = $this->setting->get_value('ordering') == 0 ? " ORDER BY comment_parent ASC, id DESC " : '';

        $page = $this->input->post('page') > 0 ? $this->input->post('page') - 1 : 0;
        $per_page = (int) $page * NUM_PER_PAGE;
        $total = $this->model->conditions($conditions)->param(array($key))->count();
        if ($total == 0) {
            return;
        }
        $pagination = new Pf_Paginator($total, NUM_PER_PAGE, 'page-comment', $page + 1);
        $data = $this->model->conditions("WHERE {$conditions} {$order_by} LIMIT  {$per_page}," . NUM_PER_PAGE)->get();
        $comments = $this->get_comment($data);
        if (empty($comments)) {
            return;
        }
        $this->get_avatar($data);
        $avatar = $this->session->get('comments_avatar');
        echo json_encode(array('comments' => show_all_comment($comments, $key, $avatar), 'total' => $total, 'pagination' => $pagination->page_links(public_url('', true), '', true), 'data_result' => $data));
    }

    /*
     * Comment, Reply, Remove
     */

    public function comment_post()
    {
        if (!is_ajax()) {
            return false;
        }
        $id = '';
        if ($this->input->has_post('id')) {
            $id = $this->input->post('id');
        }
        $key = $this->input->post('key');
        if (!Pf_Plugin_CSRF::is_valid($this->input->post('token'), $key . $id)) {
            set_message_ajax('error_token');
            return;
        }
        $message = $this->input->post('message');
        if (strlen($message) > $this->settings['maximum_characters']) {
            set_message_ajax('error_messagelength');
            return;
        }
        $comment_status = $this->settings['approve_flag'] ? 0 : 1;
        $data = array(
            'comment_content' => $message,
            'comment_author' => current_user('user-name'),
            'comment_user_id' => current_user('user-id'),
            'comment_key' => $this->input->post('key'),
            'comment_status' => $comment_status
        );
        if ((int) $id > 0) {
            $result = $this->model->conditions('id = ?')->param($id)->update($data);
        } else {
            $parent = $this->input->has_post('parent') ? $this->input->post('parent') : 0;
            $data['comment_parent'] = $parent;
            $result = $this->model->insert($data);
        }
        if ($result > 0) {
            $tmp = (int) $id > 0 ? $id : $result;
            $data_return = array(
                'id' => $tmp,
                'token_id' => Pf_Plugin_CSRF::token($key . $tmp),
                'token' => Pf_Plugin_CSRF::token($key)
            );
            if ($comment_status === 0) {
                $messages = array(
                    'username' => $data['comment_author'],
                    'comment' => $message,
                    'comment-link' => site_url() . RELATIVE_PATH . '/admin/?admin-page=comment'
                );
                $this->send_email_approve($messages);
            }
            echo json_encode($data_return);
            return;
        }
        echo set_message_ajax('error_cud');
    }

    /*
     * Delete
     */

    public function comment_delete()
    {
        if (!is_ajax()) {
            return false;
        }
        $token = $this->input->post('token');
        $key = $this->input->post('key');
        $id = $this->input->post('id');
        if (!Pf_Plugin_CSRF::is_valid($token, $key . $id)) {
            set_message_ajax('error_token');
            return;
        }
        $data = $this->model->conditions('where comment_key = ?')->param($key)->get();
        $result = array();
        get_all_children($data, $result, $id, 'comment_parent');
        array_unshift($result, $id);
        $param = implode(',', array_map('generate_param_where_in', $result));
        if ($this->model->conditions("id in({$param})")->param($result)->delete()) {
            echo true;
            return;
        }
        echo set_message_ajax('error_cud');
    }

    private function send_email_approve($data)
    {
        if (!empty($this->settings['approve'])) {
            $users = get_list_user('pf_users.id in(' . generate_where_in($this->settings['approve']) . ')', $this->settings['approve'], 'user_email,user_name');
            if (empty($users)) {
                return;
            }
            $config = array();
            $subject = Pf::email_template()->get_element_subject('pf_comment_mail_template', 'approve_comment');
            $config['subject'] = str_replace('{sitename}', $this->settings['site_name'], $subject);
            $message = Pf::email_template()->get_element_body('pf_comment_mail_template', 'approve_comment');
            foreach ($users as $item) {
                $config['to'][$item['user_email']] = $item['user_name'];
            }
            $data['sitename'] = $this->settings['site_name'];
            foreach ($data as $key => $item) {
                $message = str_replace('{' . $key . '}', $item, $message);
            }
            $config['from'] = $this->settings['email'];
            try {
                $this->mail->send($config, $message);
            } catch (Exception $ex) {
                
            }
        }
    }

    /**
     * Avatar comment
     */
    public function get_avatar($comments)
    {
        $users_comment = array();
        foreach ($comments as $comment) {
            if (!in_array($comment->comment_user_id, $users_comment)) {
                $users_comment[] = $comment->comment_user_id;
            }
        }
        $users_no_avatar_in_session = array();
        $users_avatar = $this->session->get('comments_avatar');
        if (empty($users_comment)) {
            return;
        }
        if (!empty($users_avatar)) {
            $users_no_avatar_in_session = array_diff($users_comment, array_keys($users_avatar));
        } else {
            $users_no_avatar_in_session = $users_comment;
        }
        if (!empty($users_no_avatar_in_session)) {
            $users = $this->model->table('pf_users')->select('pf_users.id as uid, user_avatar')
                            ->conditions('where id in(' . generate_where_in($users_no_avatar_in_session) . ')')
                            ->param($users_no_avatar_in_session)->get();
            foreach ($users as $user) {
                $users_avatar[$user->uid] = $user->user_avatar;
            }
            $this->session->put('comments_avatar', $users_avatar);
        }
    }

}
